// DeviceCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "DeviceCtrl.h"
#include "Include\CLS_PELCO_Interface.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "DecCtrlClientTypes.h"
#include "Include\CommonFun.h"
#include "Include\__ActionControl.h"


// CDeviceCtrl dialog

IMPLEMENT_DYNAMIC(CDeviceCtrl, CDialog)

CDeviceCtrl::CDeviceCtrl(CWnd* pParent /*=NULL*/)
	: CDialog(CDeviceCtrl::IDD, pParent)
	,m_lLogonID(-1),m_iChannel(-1),m_iPic(-1),m_bLButtonDown(FALSE)
{
}

CDeviceCtrl::~CDeviceCtrl()
{
}

void  CDeviceCtrl::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_FOCUS, GetText(IDS_CTRL_FOCUS));
 	SetDlgItemText(IDC_STATIC_ZOOM, GetText(IDS_CTRL_ZOOM));
 	SetDlgItemText(IDC_STATIC_IRIS, GetText(IDS_CTRL_RIS));
 	SetDlgItemText(IDC_BUTTON_SETPRESET, GetText(IDS_CTRL_SETPRESET));
 	SetDlgItemText(IDC_BUTTON_CALLPRESET, GetText(IDS_CTRL_CALLPRESET));
 	SetDlgItemText(IDC_BUTTON_AUTO, GetText(IDS_CTRL_AUTO));
 	SetDlgItemText(IDC_STATIC_SPEED, GetText(IDS_CTRL_SPEED));
 	SetDlgItemText(IDC_BUTTON_CLOSECTRL, GetText(IDS_CTRL_CLOSE));
}

int  CDeviceCtrl::Initialize(LONG _lLogonID, int _iChannel, int _iPic)
{
    m_lLogonID = _lLogonID;
	m_iChannel = _iChannel;
	m_iPic     = _iPic;
	m_iAddress = 0;
    
	TDECPARAM _decParam;
	memset(&_decParam,0,sizeof(_decParam));
	DEC_ClientGetDecoderPara(_lLogonID,&_decParam);

	if(_decParam.m_rs485type == 0)           //͸ͨ
	{
		TNVSITEM nvsItem;
		memset(&nvsItem,0,sizeof(nvsItem));
		DEC_ClientGetViewItem(m_lLogonID,&nvsItem, m_iChannel, m_iPic);
		m_iAddress = nvsItem.m_iAddress;
	}
	return 0;
}

void CDeviceCtrl::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_PRESET, m_EditPreset);
}


BEGIN_MESSAGE_MAP(CDeviceCtrl, CDialog)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_SPEED, &CDeviceCtrl::OnNMCustomdrawSliderSpeed)
	ON_BN_CLICKED(IDC_BUTTON_SETPRESET, &CDeviceCtrl::OnBnClickedButtonSetpreset)
	ON_BN_CLICKED(IDC_BUTTON_CALLPRESET, &CDeviceCtrl::OnBnClickedButtonCallpreset)
	ON_BN_CLICKED(IDC_BUTTON_CLOSECTRL, &CDeviceCtrl::OnBnClickedButtonClosectrl)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_AUTO, &CDeviceCtrl::OnBnClickedButtonAuto)
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CDeviceCtrl message handlers


BOOL CDeviceCtrl::PreTranslateMessage(MSG* pMsg)
{
	if( pMsg->message == WM_LBUTTONUP)//WM_LBUTTONUPϢת
	{
		if (FALSE == m_bLButtonDown)
		{
			pMsg->message = WM_LBUTTONDOWN;
			PreTranslateMessage(pMsg);
			pMsg->message = WM_LBUTTONUP;
			PreTranslateMessage(pMsg);
			return TRUE;
		}

		m_bLButtonDown = FALSE;
		switch(::GetDlgCtrlID(pMsg->hwnd))
		{
		case IDC_BUTTON_UP://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_UP);
			break;
		case IDC_BUTTON_DOWN://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_DOWN);
			break;
		case IDC_BUTTON_LEFT://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_LEFT);
			break;
		case IDC_BUTTON_RIGHT://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_RIGHT);
			break;
		case IDC_BUTTON_LEFTUP://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_LEFTUP);
			break;
		case IDC_BUTTON_RIGHTUP://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_RIGHTUP);
			break;
		case IDC_BUTTON_LEFTDOWN://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_LEFTDOWN);
			break;
		case IDC_BUTTON_RIGHTDOWN://ƶĿưť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_RIGHTDOWN);
			break;
		case IDC_BUTTON_FOCUSNEAR://۽İť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_FOCUSNEAR);
			break;
		case IDC_BUTTON_FOCUSFAR://۽Զİť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_FOCUSFAR);
			break;
		case IDC_BUTTON_ZOOMIN://䱶İť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_ZOOMIN);
			break;
		case IDC_BUTTON_ZOOMOUT://䱶Сİť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_ZOOMOUT);
			break;
		case IDC_BUTTON_IRISOPEN://򿪹Ȧİť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_IRISOPEN);
			break;
		case IDC_BUTTON_IRISCLOSE://رչȦİť
			SendMessage(WM_LBUTTONUP,IDC_BUTTON_IRISCLOSE);
			break;
		default :
			break;
		}
		KillTimer(0);
	}
	else if ( pMsg->message == WM_LBUTTONDOWN)
	{
		m_bLButtonDown = TRUE;
		switch(::GetDlgCtrlID(pMsg->hwnd))
		{
		case IDC_BUTTON_UP://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_UP);
			break;
		case IDC_BUTTON_DOWN://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_DOWN);
			break;
		case IDC_BUTTON_LEFT://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_LEFT);
			break;
		case IDC_BUTTON_RIGHT://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_RIGHT);
			break;
		case IDC_BUTTON_LEFTUP://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_LEFTUP);
			break;
		case IDC_BUTTON_RIGHTUP://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_RIGHTUP);
			break;
		case IDC_BUTTON_LEFTDOWN://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_LEFTDOWN);
			break;
		case IDC_BUTTON_RIGHTDOWN://ɿƶĿưť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_RIGHTDOWN);
			break;
		case IDC_BUTTON_FOCUSNEAR://ɿ۽İť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_FOCUSNEAR);
			break;
		case IDC_BUTTON_FOCUSFAR://ɿ۽Զİť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_FOCUSFAR);
			break;
		case IDC_BUTTON_ZOOMIN://ɿ䱶İť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_ZOOMIN);
			break;
		case IDC_BUTTON_ZOOMOUT://ɿ䱶Сİť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_ZOOMOUT);
			break;
		case IDC_BUTTON_IRISOPEN://ɿȦİť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_IRISOPEN);
			break;
		case IDC_BUTTON_IRISCLOSE://ɿȦصİť
			SendMessage(WM_LBUTTONDOWN,IDC_BUTTON_IRISCLOSE);
			break;
		default :
			break;
		}
	}
	if (pMsg->message == WM_KEYDOWN || pMsg->message == WM_KEYUP)
	{
		if (pMsg->wParam == VK_ESCAPE)
		{
			return true;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CDeviceCtrl::OnLButtonDown(UINT nFlags, CPoint point)
{
	CSliderCtrl *sldSpeed = (CSliderCtrl *)GetDlgItem(IDC_SLIDER_SPEED);
	int iSpeed = sldSpeed->GetPos();
	switch(nFlags)
	{
	case IDC_BUTTON_UP://ƶ

		//DeviceControl(MOVE, 0 ,iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_UP, 0, 0, iSpeed);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_DOWN://ƶ
		//DeviceControl(MOVE,0, 0-iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_DOWN, 0, 0, iSpeed);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_LEFT://ƶ
		//DeviceControl(MOVE, 0-iSpeed, 0, 0);
		DeviceControlEx(PROTOCOL_MOVE_LEFT, 0, iSpeed, 0);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_RIGHT://ƶ
		//DeviceControl(MOVE,iSpeed, 0, 0);
		DeviceControlEx(PROTOCOL_MOVE_RIGHT, 0, iSpeed, 0);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_LEFTUP://ƶ
		//DeviceControl(MOVE, 0-iSpeed, iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_UP_LEFT, 0, iSpeed, iSpeed);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_RIGHTUP://ƶ
		//DeviceControl(MOVE, iSpeed, iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_UP_RIGHT, 0, iSpeed, iSpeed);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_LEFTDOWN://ƶ
		//DeviceControl(MOVE, 0-iSpeed, 0-iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_DOWN_LEFT, 0, iSpeed, iSpeed);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_RIGHTDOWN://ƶ
		//DeviceControl(MOVE, iSpeed, 0-iSpeed,0);
		DeviceControlEx(PROTOCOL_MOVE_DOWN_RIGHT, 0, iSpeed, iSpeed);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_FOCUSNEAR://۽
		//DeviceControl(FOCUS_NEAR, 0, 0, 0);
		DeviceControlEx(PROTOCOL_FOCUS_ON, 0, 0, 0);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_FOCUSFAR://۽Զ
		//DeviceControl(FOCUS_FAR,0, 0, 0);
		DeviceControlEx(PROTOCOL_FOCUS_OFF, 0, 0, 0);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_ZOOMIN://䱶
		//DeviceControl(ZOOM_SMALL, 0, 0, 0);
		DeviceControlEx(PROTOCOL_ZOOMIN, 0, 0, 0);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_ZOOMOUT://䱶С
		//DeviceControl(ZOOM_BIG, 0, 0, 0);
		DeviceControlEx(PROTOCOL_ZOOMOUT, 0, 0, 0);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_IRISOPEN://Ȧ
		//DeviceControl(IRIS_OPEN,0, 0, 0);
		DeviceControlEx(PROTOCOL_IRIS_OPEN, 0, 0, 0);
		SetTimer(0,500,NULL);
		break;
	case IDC_BUTTON_IRISCLOSE://Ȧ
		//DeviceControl(IRIS_CLOSE,0, 0, 0);
		DeviceControlEx(PROTOCOL_IRIS_CLOSE, 0, 0, 0);
		SetTimer(0,500,NULL);
		break;
	default :
		break;
	}	
	CDialog::OnLButtonDown(nFlags, point);
}

void CDeviceCtrl::OnLButtonUp(UINT nFlags, CPoint point)
{
	CSliderCtrl *sldSpeed = (CSliderCtrl *)GetDlgItem(IDC_SLIDER_SPEED);
	int iSpeed = sldSpeed->GetPos();
	switch(nFlags)
	{
	case IDC_BUTTON_UP://ֹͣƶ
		//DeviceControl(MOVE_STOP, 0, iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP, 0, 0, 0);
		break;
	case IDC_BUTTON_DOWN://ֹͣƶ
		//DeviceControl(MOVE_STOP, 0, 0-iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP, 0, 0, 0);
		break;
	case IDC_BUTTON_LEFT://ֹͣƶ
		//DeviceControl(MOVE_STOP, 0-iSpeed, 0, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP, 0, 0, 0);
		break;
	case IDC_BUTTON_RIGHT://ֹͣƶ
		//DeviceControl(MOVE_STOP, iSpeed, 0, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP, 0, 0, 0);
		break;
	case IDC_BUTTON_LEFTUP://ֹͣƶ
		//DeviceControl(MOVE_STOP,0-iSpeed, iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP, 0, 0, 0);
		break;
	case IDC_BUTTON_RIGHTUP://ֹͣƶ
		//DeviceControl(MOVE_STOP, iSpeed, iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP,  0, 0, 0);
		break;
	case IDC_BUTTON_LEFTDOWN://ֹͣƶ
		//DeviceControl(MOVE_STOP, 0-iSpeed, 0-iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP, 0, 0, 0);
		break;
	case IDC_BUTTON_RIGHTDOWN://ֹͣƶ
		//DeviceControl(MOVE_STOP, iSpeed, 0-iSpeed, 0);
		DeviceControlEx(PROTOCOL_MOVE_STOP, 0, 0, 0);
		break;
	case IDC_BUTTON_FOCUSNEAR://ֹͣ۽
		//DeviceControl(FOCUS_NEAR_STOP, 0, 0, 0);
		DeviceControlEx(PROTOCOL_PTZ_FST, 0, 0, 0);
		break;
	case IDC_BUTTON_FOCUSFAR://ֹͣ۽Զ
		//DeviceControl(FOCUS_FAR_STOP, 0, 0, 0);
		DeviceControlEx(PROTOCOL_PTZ_FST, 0, 0, 0);
		break;
	case IDC_BUTTON_ZOOMIN://ֹͣ䱶
		//DeviceControl(ZOOM_SMALL_STOP, 0, 0, 0);
		DeviceControlEx(PROTOCOL_IST, 0, 0, 0);
		break;
	case IDC_BUTTON_ZOOMOUT://ֹͣ䱶С
		//DeviceControl(ZOOM_BIG_STOP, 0, 0, 0);
		DeviceControlEx(PROTOCOL_IST, 0, 0, 0);
		break;
	case IDC_BUTTON_IRISOPEN://ֹͣȦ
		//DeviceControl(IRIS_OPEN_STOP, 0, 0, 0);
		DeviceControlEx(PROTOCOL_IA_ON, 0, 0, 0);
		break;
	case IDC_BUTTON_IRISCLOSE://ֹͣȦز
		//DeviceControl(IRIS_CLOSE_STOP, 0, 0, 0);
		DeviceControlEx(PROTOCOL_IA_ON, 0, 0, 0);
		break;
	default :
		break;
	}	
	CDialog::OnLButtonUp(nFlags, point);
}

int CDeviceCtrl::DeviceControl(int _iAct, int _iXSpeed, int _iYSpeed, int _iPreset)
{
	InitData();
	m_data.point.x = _iXSpeed;
	m_data.point.y = _iYSpeed;
	m_data.iPreset = _iPreset;
	CString szCaption;
	GetDlgItemText(IDC_BUTTON_AUTO,szCaption);
	if (szCaption == GetText(IDS_SETTING_STOP))
	{
		SetDlgItemText(IDC_BUTTON_AUTO, GetText(IDS_SETTING_AUTO));
	}
	GetControlCode(_iAct,&m_data);
    return SendControlCode();
}

int CDeviceCtrl::DeviceControlEx(int iActionType, int iControlType, int iParam1, int iParam2)
{
	PtzControlPara tPtzCtrPara = {0};
	tPtzCtrPara.iSize = sizeof(PtzControlPara);
	tPtzCtrPara.iActionType = iActionType;
	tPtzCtrPara.iControlType = iControlType;
	tPtzCtrPara.iParam1 = iParam1;
	tPtzCtrPara.iParam2 = iParam2;
	m_tControlPara = tPtzCtrPara;
	int iRet = DEC_ClientSendCommand(m_lLogonID, m_iChannel,m_iPic, DEC_COMMAND_PTZ_CONTROL, &tPtzCtrPara, sizeof(PtzControlPara));
	if(iRet < 0)
	{
		//AddLog(LOG_TYPE_FAIL,"","DeviceControlEx Error!LogonID(%d)",m_lLogonID);
		return -1;
	}

	return 0;
}

void   CDeviceCtrl::InitData()
{
	memset(&m_data,0,sizeof(m_data));
	m_data.iAddress = m_iAddress;
}

void CDeviceCtrl::OnNMCustomdrawSliderSpeed(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);

	CSliderCtrl *sldSpeed = (CSliderCtrl *)GetDlgItem(IDC_SLIDER_SPEED);
	char cSpeed[16];
	sprintf_s(cSpeed,16,"%d",sldSpeed->GetPos());
	GetDlgItem(IDC_STATIC_SPEEDNUM)->SetWindowText(CA2CT(cSpeed));	
	sldSpeed = NULL;

	*pResult = 0;
}

BOOL CDeviceCtrl::OnInitDialog()
{
	CDialog::OnInitDialog();
    LoadSurfaceResource();
	CSliderCtrl *sldSpeed = (CSliderCtrl *)GetDlgItem(IDC_SLIDER_SPEED);
	sldSpeed->SetRange(0,100);
	sldSpeed->SetPos(50);
	sldSpeed = NULL;

	SetDlgItemInt(IDC_EDIT_PRESET, 1);
	SetDlgItemText(IDD_DIALOG_DEVICECTRL, _T("Device Control"));

	CLS_PELCO_Interface::m_astrFilePath   = "DOME_Pelco_P.dll";
	if(CLS_PELCO_Interface::LoadDLL())
	{
		this->SetWindowText(GetText(IDS_SETTING_INITIALIZEOK));
	}
	else
	{
		this->SetWindowText(GetText(IDS_SETTING_INITIALIZEFAIL));
	}

	return FALSE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CDeviceCtrl::OnBnClickedButtonSetpreset()
{
	int iPreset = GetDlgItemInt(IDC_EDIT_PRESET);
	if(iPreset > 255 || iPreset < 1)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		m_EditPreset.SetFocus();
		return;
	}
	CString szCaption;
	GetDlgItemText(IDC_BUTTON_AUTO,szCaption);
	if (szCaption == GetText(IDS_SETTING_STOP))
	{
		SetDlgItemText(IDC_BUTTON_AUTO, GetText(IDS_SETTING_AUTO));
	}
	DeviceControlEx(PROTOCOL_SET_PRESET, 0, iPreset, 0);
	//SendControlCode();
}

void CDeviceCtrl::OnBnClickedButtonCallpreset()
{
	int iPreset = GetDlgItemInt(IDC_EDIT_PRESET);
	if(iPreset > 255 || iPreset < 1)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		m_EditPreset.SetFocus();
		return;
	}
	CString szCaption;
	GetDlgItemText(IDC_BUTTON_AUTO,szCaption);
	if (szCaption == GetText(IDS_SETTING_STOP))
	{
		SetDlgItemText(IDC_BUTTON_AUTO, GetText(IDS_SETTING_AUTO));
	}
	DeviceControlEx(PROTOCOL_PRESET, 0, iPreset, 0);
	//SendControlCode();
}

void CDeviceCtrl::OnBnClickedButtonClosectrl()
{
	EndDialog(0);
}

int CDeviceCtrl::SendControlCode()
{
#ifdef _DEBUG
	CString asCode = "*";
	for(int i=0;i<m_data.iCount;i++)
	{
		CString szTemp;
		szTemp.Format("%d",m_data.DecBuf[i]);
		asCode = asCode + szTemp + "*";
	}
	asCode += "\n";
	OutputDebugString(asCode);
#endif
	int iRet = DEC_Client485Send(m_lLogonID,m_data.DecBuf,m_data.iCount, m_iChannel,m_iPic);
	if (0 != iRet)
	{
		CString szMsg;
		szMsg.Format("send result:%d\n", iRet);
		OutputDebugString(szMsg);
	}
	return iRet;
}

void CDeviceCtrl::OnTimer(UINT_PTR nIDEvent)
{
    //SendControlCode();
	DEC_ClientSendCommand(m_lLogonID, m_iChannel,m_iPic, DEC_COMMAND_PTZ_CONTROL, &m_tControlPara, sizeof(PtzControlPara));
	CDialog::OnTimer(nIDEvent);
}

void CDeviceCtrl::OnBnClickedButtonAuto()
{
	CString strCaption;
	int iRet = -1;
	GetDlgItem(IDC_BUTTON_AUTO)->GetWindowText(strCaption);
	if (strCaption == GetText(IDS_CTRL_AUTO))//ΪAuto״̬
	{
		iRet = DeviceControlEx(PROTOCOL_CRUISE_START, 0, 0 ,0);//úDevControlHOR_AUTO
		if (iRet == 0)
		{
			GetDlgItem(IDC_BUTTON_AUTO)->SetWindowText(GetText(IDS_CTRL_STOP));
		}		
	}
	else//ΪStop״̬
	{
		iRet = DeviceControlEx(PROTOCOL_CRUISE_STOP, 0, 0, 0);//úDevControlHOR_AUTO STOP
		if (iRet == 0)
		{
			GetDlgItem(IDC_BUTTON_AUTO)->SetWindowText(GetText(IDS_CTRL_AUTO));
		}		
	}
}

void CDeviceCtrl::OnDestroy()
{
	CDialog::OnDestroy();
	CLS_PELCO_Interface::FreeDLL();
}


